<!doctype html>
<html <?php language_attributes(); ?>>

<head>
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	 <!-- Meta Title & Meta Description on Home Page if SEO Yoast Disabled -->
	<?php if ( true == get_theme_mod( 'switch_on', true ) ) : ?>
	<?php
	
	if(class_exists('WPSEO_Admin_Init')){
		
		?>
    <?php 	if(is_home() || is_front_page()): ?>
    <meta property="og:title" content="<?php echo get_bloginfo('name');?>">	
	<meta property="og:description" content="<?php echo get_theme_mod('meta_desc');?>">
	<meta property="og:image" content="<?php echo get_theme_mod('link_setting');?>">
	<meta property="og:url" content="<?php echo get_site_url();?>">
   <?php endif;?>
		<?php
	}
	
	
	?>
	<!-- Meta Title & Meta Description on Home Page if SEO Yoast Activated -->
	<?php elseif(true == get_theme_mod( 'switch_on', true ) || is_home() || is_front_page()): ?>
	<meta property="og:description" content="<?php echo get_theme_mod('meta_desc');?>">
	<meta property="og:image" content="<?php echo get_theme_mod('link_setting');?>">
	<?php else: ?>
	<!-- SEO Yoast Tags if above condition failed  -->
	<?php echo do_action('vidorev_meta_tags'); ?>
	<?php endif;?>
   <!-- Meta Title & Meta Description on Single Post / Category if SEO Yoast Disabled -->
	<?php if ( true == get_theme_mod( 'switch_on_two', true ) ) : ?>
	<?php
	
	if(!class_exists('WPSEO_Admin_Init')){
		?>
		
	<?php if(is_single() || is_archive()): ?>
    <meta property="og:title" content="<?php echo get_bloginfo('name');?>">	
	<meta property="og:description" content="<?php echo get_theme_mod('meta_desc1');?>">
	<meta property="og:image" content="<?php echo get_theme_mod('link_setting1');?>">
	<meta property="og:url" content="<?php echo get_site_url();?>">
	
	<?php endif;?>
	<?php
	}
		
	
	?>
	 <!-- Meta Title & Meta Description on Single Post / Category SEO Yoast Activatate  -->
	<?php elseif(true == get_theme_mod( 'switch_on_two', true ) || is_single() || is_archive()): ?>
	<meta property="og:description" content="<?php echo get_theme_mod('meta_desc1');?>">
	
	<?php else: ?>
	 <!-- SEO Yoast Tags if above condition failed  -->
	<?php echo do_action('vidorev_meta_tags'); ?>
	<?php endif;?>	
	
	
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<?php wp_head(); ?>
</head>

<body <?php body_class();?>>
	
	<?php
	wp_body_open();
	$header_style = vidorev_header_style();						
	?>
	
	<div id="site-wrap-parent" class="site-wrap-parent site-wrap-parent-control">
		
		<?php 
		if($header_style=='side'){
			get_template_part('template-parts/header-navigation-styles/header', $header_style.'-menu');
		}
		?>
			
		<div id="site-wrap-children" class="site-wrap-children site-wrap-children-control">
			
            <?php if(!beeteam368_return_embed()){?>
            
				<?php do_action('vidorev_instagram_feed', 'header');?>
                
                <header id="site-header" class="site-header header-<?php echo esc_attr($header_style);?> site-header-control">
					<?php
                    if ( ! function_exists( 'elementor_theme_do_location' ) || ! elementor_theme_do_location( 'header' ) ) {
                        get_template_part( 'template-parts/vidorev-header' );
                    }
					?>
                    <?php do_action('vidorev_page_slider');?>
                </header>
                
            <?php }?>    