<?php
/*
 customizer config
 */
Kirki::add_config( 'meta_img_field', array(
	'capability'    => 'edit_theme_options',
	'option_type'   => 'theme_mod',
));

Kirki::add_panel( 'meta_desc_id', array(
    'priority'    => 10,
    'title'       => esc_html__( 'Meta Changes', 'kirki' ),
    'description' => esc_html__( 'Change meta image and description', 'kirki' ),
) );

Kirki::add_section( 'meta_img_id', array(
    'title'          => esc_html__( 'Default Image Url', 'kirki' ),
    'description'    => esc_html__( 'Default Image url to get image', 'kirki' ),
    'panel'          => 'meta_desc_id',
    'priority'       => 160,
) );

Kirki::add_field( 'meta_img_field', [
	'type'     => 'link',
	'settings' => 'link_setting',
	'label'    => __( 'Image url', 'kirki' ),
	'section'  => 'meta_img_id',
	'default'  => 'https://mapsteps.com/',
	'priority' => 10,

]);

Kirki::add_field( 'meta_img_field', [
	'type'     => 'text',
	'settings' => 'meta_desc',
	'label'    => esc_html__( 'Enter meta description', 'kirki' ),
	'section'  => 'meta_img_id',

	'priority' => 10,

]);
Kirki::add_field( 'meta_img_field', [
	'type'        => 'switch',
	'settings'    => 'switch_on',
	'label'       => esc_html__( 'Image url', 'kirki' ),
	'section'     => 'meta_img_id',
	'default'     => '1',
	'priority'    => 10,
	'choices'     => [
		'on'  => esc_html__( 'Enable', 'kirki' ),
		'off' => esc_html__( 'Disable', 'kirki' ),
	],
] );

Kirki::add_field( 'meta_img_field', [
	'type'     => 'link',
	'settings' => 'link_setting1',
	'label'    => __( 'Home Page Meta', 'kirki' ),
	'section'  => 'meta_img_id',
	'default'  => 'https://mapsteps.com/',
	'priority' => 10,

]);

Kirki::add_field( 'meta_img_field', [
	'type'     => 'text',
	'settings' => 'meta_desc1',
	'label'    => esc_html__( 'Enter Post meta description', 'kirki' ),
	'section'  => 'meta_img_id',

	'priority' => 10,

]);


Kirki::add_field( 'meta_img_field', [
	'type'        => 'switch',
	'settings'    => 'switch_on_two',
	'label'       => esc_html__( 'Post Meta', 'kirki' ),
	'section'     => 'meta_img_id',
	'default'     => '1',
	'priority'    => 10,
	'choices'     => [
		'on'  => esc_html__( 'Enable', 'kirki' ),
		'off' => esc_html__( 'Disable', 'kirki' ),
	],
] );
